echo off

REM ---------------------------------------------------
REM Creates a Windows Service for a java program...
REM ---------------------------------------------------


REM ---------------------------------------------------
REM The service display name.
REM ---------------------------------------------------
set TITLE="Message Manager"


REM ---------------------------------------------------
REM The root directory of the Java VM you want to use.
REM ---------------------------------------------------
set JAVA_HOME=c:\Services\jdk1.8.0_111

REM ---------------------------------------------------
REM The root directory of the application
REM ---------------------------------------------------
set APPROOT=%CD%


REM ---------------------------------------------------
REM The location of all application dependent jar files, 
REM classes, and properties.
REM ---------------------------------------------------
set JARS=%APPROOT%\lib
set BIN=%APPROOT%\bin


REM ---------------------------------------------------
REM The classpath to be use by the application.
REM ---------------------------------------------------
set CP=%APPROOT%
set CP=%CP%;%BIN%
set CP=%CP%;%JARS%\commons-lang3-3.4.jar
set CP=%CP%;%JARS%\entirex.jar
set CP=%CP%;%JARS%\intarsys-delta.jar
set CP=%CP%;%JARS%\javax.mail.jar
set CP=%CP%;%JARS%\log4j-api-2.3.jar
set CP=%CP%;%JARS%\log4j-core-2.3.jar


REM ---------------------------------------------------
REM Service Parameter - The Java VM library location
REM ---------------------------------------------------
set JVM=%JAVA_HOME%\jre\bin\server\jvm.dll


REM ---------------------------------------------------
REM Service Parameter - The class path to use.
REM ---------------------------------------------------
set JCP=-Djava.class.path=%CP%


REM ---------------------------------------------------
REM Service Parameter - The library path to use.
REM ---------------------------------------------------
set JLP=-Djava.library.path=%APPROOT%\cryptography


REM ---------------------------------------------------
REM Service Parameter - The main class name.
REM ---------------------------------------------------
set CMAIN=fccsc.manager.MessageManager


REM ---------------------------------------------------
REM Service Parameter - The shutdown class name.
REM ---------------------------------------------------
set CSHUT=fccsc.manager.MessageManager


REM ---------------------------------------------------
REM Service Parameter - The shutdown class METHOD name.
REM ---------------------------------------------------
set MSHUT=doShutdown


REM ---------------------------------------------------
REM Service Parameter - Log file for System.out calls.
REM ---------------------------------------------------
set LOUT="%APPROOT%\logs\system.out"


REM ---------------------------------------------------
REM Service Parameter - Log file for System.err calls.
REM ---------------------------------------------------
set LERR="%APPROOT%\logs\system.err"


REM ---------------------------------------------------
REM Determine whether to use JavaService 32 or 64 bit.
REM ---------------------------------------------------
echo %PROCESSOR_ARCHITECTURE% | find /i "x86" > nul
if %errorlevel%==0 (
    echo   32-bit OS detected
    set JAVASERVICE=JavaService32.exe
) else (
    echo   64-bit OS detected
    set JAVASERVICE=JavaService64.exe
)


REM ---------------------------------------------------
REM The final service command using all of the above.
REM ---------------------------------------------------
echo	

%JAVASERVICE% -install %TITLE% %JVM% %JCP% %JLP% -start %CMAIN% -stop %CSHUT% -method %MSHUT% -out %LOUT% -err %LERR% -current %APPROOT% -path %JAVA_HOME%\bin

pause