package fccsc.manager;


public interface IMessage
{
	/**
	 * Sets the incoming data to process.
	 * @param p_data the data to be processed.
	 */
	public void setRequest( String p_data ) throws Exception;

	/**
	 * Returns the request data that was sent to this process.
	 * @return the request data.
	 */
	public String getRequest() throws Exception;

	/**
	 * Sets the outgoing response data.
	 * @param p_data the response data.
	 */
	public void setResponse( String p_data ) throws Exception;

	/**
	 * Returns the response message that this process needs to send back.
	 * @return response message.
	 */
	public String getResponse() throws Exception;

	/**
	 * Process this message.
	 */
	public void process() throws Exception;


	/**
	 * Returns the "call back" ip address.
	 * @return a string representation of an ip address (xxx.xxx.xxx.xxx).
	 */
	public String getCallBackIpAddress();

	/**
	 * Sets the "call back" ip address.
	 * @param p_ipAddress a string representation of an ip address (xxx.xxx.xxx.xxx).
	 */
	public void setCallBackIpAddress( String p_ipAddress );

	/**
	 * Returns the "call back" ip port.
	 * @return an integer.
	 */
	public int getCallBackIpPort();

	/**
	 * Sets the "call back" ip port.
	 * @param p_ipPort the ip port.
	 */
	public void setCallBackIpPort( int p_ipPort );
}