package fccsc.manager.apps.passphrase;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

import fccsc.manager.crypto.PassPhrase;


public class MainPanel
	extends JPanel
{
	private static final long serialVersionUID = 1L;

	private String pathLocation = "";

    private JPanel jPanelCenter = new JPanel();
    private JPanel jPanelSouth = new JPanel();
    private Border border1;
    private TitledBorder titledBorder1;
    private Border border2;
    private JLabel jLabelStatus = new JLabel();
    private JLabel jLabel1 = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JLabel jLabel2 = new JLabel();
    private JTextField jTextFieldPassphrase = new JTextField();
    private JLabel jLabel3 = new JLabel();
    private JTextField jTextFieldLocation = new JTextField();
    private JButton jButtonBrowse = new JButton();
    private JButton jButtonEncrypt = new JButton();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    public MainPanel()
    {
	try
	{
	    jbInit();

		/////////////////////////////////////////////////////////////
		//
		// get the current directory path
		// and build relative a directory path
		//
		File f = new File( "." );
		this.pathLocation = f.getCanonicalPath() +
							File.separator + "cryptography" +
							File.separator + "passphrase.pph";

		// set this as a default
		this.jTextFieldLocation.setText( this.pathLocation );
	}
	catch(Exception e)
	{
	    e.printStackTrace();
	}
    }
    private void jbInit() throws Exception
    {
		border1 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
		titledBorder1 = new TitledBorder(border1,"Pass Phrase Encryptor");
		border2 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
		this.setLayout(gridBagLayout3);
		jPanelCenter.setBorder(titledBorder1);
		jPanelCenter.setLayout(gridBagLayout2);
		jPanelSouth.setBorder(border2);
		jPanelSouth.setLayout(gridBagLayout1);
		jLabelStatus.setForeground(Color.blue);
		jLabelStatus.setPreferredSize(new Dimension(200, 16));
		jLabelStatus.setText("Ready to encrypt your pass phrase.");
		jLabel1.setText("Status: ");
		jLabel2.setText("Pass Phrase");
		jTextFieldPassphrase.setText("");
		jTextFieldPassphrase.setColumns(25);
		jLabel3.setText("File Location");
		jTextFieldLocation.setText("");
		jTextFieldLocation.setColumns(20);
		jButtonBrowse.setText("Browse");
		jButtonBrowse.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
			jButtonBrowse_actionPerformed(e);
			}
		});
		jButtonEncrypt.setText("Encrypt");
		jButtonEncrypt.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
			jButtonEncrypt_actionPerformed(e);
			}
		});
		this.add(jPanelCenter,    new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 2, 2), 0, 0));
		this.add(jPanelSouth,    new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 2, 2), 0, 0));
		jPanelSouth.add(jLabelStatus,   new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
		jPanelSouth.add(jLabel1,        new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
		jPanelCenter.add(jLabel2,  new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
		jPanelCenter.add(jTextFieldPassphrase,     new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
		jPanelCenter.add(jLabel3,   new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
		jPanelCenter.add(jTextFieldLocation,   new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
		jPanelCenter.add(jButtonBrowse,   new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
				,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
		jPanelCenter.add(jButtonEncrypt,   new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0
				,GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    }

    void jButtonBrowse_actionPerformed(ActionEvent e)
    {
		try
		{
			// Note: source for ExampleFileFilter can be found in FileChooserDemo,
			// under the demo/jfc directory in the Java 2 SDK, Standard Edition.
			PassPhraseFileFilter filter = new PassPhraseFileFilter(
													"pph", "Encrypted Pass Phrase" );
			JFileChooser chooser = new JFileChooser();
		    chooser.setFileFilter( filter );
			chooser.setCurrentDirectory( new File( "." ) );

			int returnVal = chooser.showOpenDialog( this );

			if ( returnVal == JFileChooser.APPROVE_OPTION )
			{
				this.pathLocation = chooser.getSelectedFile().getCanonicalPath();
				this.jTextFieldLocation.setText( this.pathLocation );
			}
		}
		catch ( Exception ex )
		{
			ex.printStackTrace();
		}
    }


    void jButtonEncrypt_actionPerformed(ActionEvent e)
    {
		this.jLabelStatus.setText( "Please wait ..." );

		String passPhrase = jTextFieldPassphrase.getText();

		if ( passPhrase.trim().length() == 0 )
		{
			this.jLabelStatus.setText( "Encryption aborted! Pass phrase is empty!" );

			String msg =    "Pass phrase is empty !\n\n" +
							"Provide a pass phrase and try again.";

			JOptionPane.showMessageDialog(  this, msg, "Encryption Aborted",
											JOptionPane.ERROR_MESSAGE );
			return;
		}


		try
		{
			this.pathLocation = this.jTextFieldLocation.getText();

			File f = new File( this.pathLocation );
			boolean fileExists = f.exists();

			if ( !fileExists )
			{
				String msg =    "The following file does not exist:\n\n" +
								f.getCanonicalPath() +
							    "\n\nWould you like to create this file ?\n";

				int result = JOptionPane.showConfirmDialog( this, msg );

				if ( result == JOptionPane.OK_OPTION )
				{
					this.jLabelStatus.setText( "Creating new file ..." );
					fileExists = f.createNewFile();
				}
				else
				{
					this.jLabelStatus.setText( "Encryption aborted!" );

					msg = "You selected not to create the new file.\n\n" +
						  "- No new file will be created.\n" +
						  "- No encryption will be performed.\n\n" +
						  "You must select and create a file in order to proceed with " +
						  "the encryption.";

					JOptionPane.showMessageDialog(  this, msg, "Encryption Aborted",
													JOptionPane.WARNING_MESSAGE );
				}
			}

			if ( fileExists )
			{
				PassPhrase phrase = new PassPhrase( this.pathLocation );
				phrase.setPassPhrase( passPhrase.getBytes() );
				phrase.fileSave();

			    this.jLabelStatus.setText( "Encryption complete." );
			}
		}
		catch ( Exception ex )
		{
			ex.printStackTrace();
			this.jLabelStatus.setText( ex.getMessage() );
		}
    }
}