package fccsc.manager.crypto;

import intarsys.crypto.Algorithms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;


public class PassPhrase
{
	private String  filePath   = "";
	private byte [] passPhrase = {};


//	public static void
//	main( String [] args )
//	{
//		String passPhrase = "28#jTpok&107GwzX";
//		String filePath   = "D:\\code\\projects\\fccsc\\manager\\cryptography\\balonie.pph";
//
//		System.out.print( "Original (" + passPhrase.length() + ")" );
//		System.out.println( " [" + passPhrase + "]" );
//
//		PassPhrase pass     = new PassPhrase( filePath );
//		pass.setPassPhrase( passPhrase.getBytes() );
//		pass.fileSave();
//
//		byte [] arrSaved = pass.getPassPhrase();
//		System.out.print( "Saved    (" + arrSaved.length + ") [" );
//		for ( int i = 0; i < arrSaved.length; i++ )
//		{
//			System.out.print( (char) arrSaved[ i ] );
//		}
//		System.out.println( "]" );
//
//		pass = new PassPhrase( filePath );
//		pass.fileLoad();
//
//		byte [] arrLoaded = pass.getPassPhrase();
//		System.out.print( "Loaded   (" + arrLoaded.length + ") [" );
//		for ( int i = 0; i < arrLoaded.length; i++ )
//		{
//			System.out.print( (char) arrLoaded[ i ] );
//		}
//		System.out.println( "]" );
//	}


    public
	PassPhrase( String p_filePath )
    {
		this.filePath = p_filePath;
    }


	public String  getFilePath()   { return this.filePath; }
	public byte [] getPassPhrase() { return this.passPhrase; }

	public void    setPassPhrase( byte [] p_passPhrase ) { this.passPhrase = p_passPhrase; }


	public void
	fileSave()
	{
		File             f   = new File( this.filePath );
		FileOutputStream fos = null;

		try
		{
			if ( !f.exists() ) { f.createNewFile(); }

			byte [] arrPhrase = Algorithms.blowfish( this.passPhrase, true );
			//System.out.print( "Encrypted (" + arrPhrase.length + ") [" );
			//for ( int i = 0; i < arrPhrase.length; i++ )
			//{
			//	System.out.print( (char) arrPhrase[ i ] );
			//}
			//System.out.println( "]" );

		    //int c;
			fos = new FileOutputStream( f );
		    fos.write( arrPhrase );
		}
		catch ( IOException ex )
		{
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				fos.close();
			}
			catch ( IOException ex1 )
			{
				ex1.printStackTrace();
			}
		}
	}

	public void
	fileLoad()
	{
		File            f   = new File( this.filePath );
		FileInputStream fis = null;

		int     c;
		int     SIZE    = 20;
		int     counter = 0;
		byte [] arrTemp = {};
		byte [] arrData = new byte[ SIZE ];

		try
		{
			if ( f.exists() )
			{
				fis = new FileInputStream( f );

				while ( (c = fis.read()) != -1 )
				{
				    if ( counter == SIZE )
					{
						arrTemp = new byte[ counter ];

						for ( int i = 0; i < arrData.length; i++ )
						{
							arrTemp[ i ] = arrData[ i ];
						}

						arrData = new byte[ counter + SIZE ];

						for ( int i = 0; i < arrTemp.length; i++ )
						{
						    arrData[ i ] = arrTemp[ i ];
						}
					}

					arrData[ counter++ ] = (byte) c;
				}

				this.passPhrase = new byte[ counter ];

				for ( int i = 0; i < counter; i++ )
				{
					this.passPhrase[ i ] = arrData[ i ];
				}

				this.passPhrase = Algorithms.blowfish( this.passPhrase, false );
				//System.out.print( "Decrypted (" + this.passPhrase.length + ") [" );
				//for ( int i = 0; i < this.passPhrase.length; i++ )
				//{
				//	System.out.print( (char) this.passPhrase[ i ] );
				//}
				//System.out.println( "]" );
			}
		}
		catch ( IOException ex )
		{
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				if ( f.exists() )
				{
					fis.close();
				}
			}
			catch ( IOException ex1 )
			{
				ex1.printStackTrace();
			}
		}
	}
}