package fccsc.manager.data;

import java.util.Vector;


public class Email
{
	private String contentType  = "text/plain";
	private String subject      = "";
	private String body         = "";

	private Vector<String> vAddressFROM = new Vector<String>( 2, 2 );
	private Vector<String> vAddressTO   = new Vector<String>( 2, 2 );
	private Vector<String> vAddressCC   = new Vector<String>( 2, 2 );
	private Vector<String> vAddressBCC  = new Vector<String>( 2, 2 );


    public
	Email( String p_contentType )
    {
		this.contentType = p_contentType;
    }


	public void
	clear()
	{
		this.contentType = "";
		this.subject     = "";
		this.body        = "";

		this.vAddressFROM.removeAllElements();
		this.vAddressTO.removeAllElements();
		this.vAddressCC.removeAllElements();
		this.vAddressBCC.removeAllElements();
	}



	public String
	getContentType() { return this.contentType; }

	public void
	setContentType( String p_contentType ) { this.contentType = p_contentType; }



	public String
	getSubject() { return this.subject; }

	public void
	setSubject( String p_subject ) { this.subject = p_subject; }



	public String
	getBody() { return this.body ; }

	public void
	setBody( String p_body ) { this.body = p_body; }


	public Vector<String>
	getAddressFROM() { return this.vAddressFROM; }

	public void
	addAddressFROM( String p_address ) { this.vAddressFROM.addElement( p_address ); }


	public Vector<String>
	getAddressTO() { return this.vAddressTO; }

	public void
	addAddressTO( String p_address ) { this.vAddressTO.addElement( p_address ); }


	public Vector<String>
	getAddressCC() { return this.vAddressCC; }

	public void
	addAddressCC( String p_address ) { this.vAddressCC.addElement( p_address ); }


	public Vector<String>
	getAddressBCC() { return this.vAddressBCC; }

	public void
	addAddressBCC( String p_address ) { this.vAddressBCC.addElement( p_address ); }


	public String
	toString()
	{
		StringBuffer buffer = new StringBuffer();

		buffer.append( "\nEmail" );
		buffer.append( "\n   Content Type   [" + this.contentType + "]" );

		buffer.append( "\n   FROM addresses [" );
		for ( int i = 0; i < vAddressFROM.size(); i++ )
		{
	        buffer.append( vAddressFROM.elementAt( i ) + ", " );
		}
		buffer.append( "]" );

		buffer.append( "\n   TO addresses   [" );
		for ( int i = 0; i < vAddressTO.size(); i++ )
		{
	        buffer.append( vAddressTO.elementAt( i ) + ", " );
		}
		buffer.append( "]" );

		buffer.append( "\n   CC addresses   [" );
		for ( int i = 0; i < vAddressCC.size(); i++ )
		{
	        buffer.append( vAddressCC.elementAt( i ) + ", " );
		}
		buffer.append( "]" );

		buffer.append( "\n   BCC addresses  [" );
		for ( int i = 0; i < vAddressBCC.size(); i++ )
		{
	        buffer.append( vAddressBCC.elementAt( i ) + ", " );
		}
		buffer.append( "]" );

		buffer.append( "\n   Subject        [" + this.subject + "]" );
		buffer.append( "\n   Body           [" + this.body    + "]" );
		buffer.append( "\n" );

		return buffer.toString();
	}
}