package fccsc.manager.data.edi;

import intarsys.util.StringTools;

public final class ControlBlock
	extends AbstractBlock
{
	public static final int    SIZE = 60;
	public static final String FEDI = "FEDI";
	public static final String FXML = "FXML";


    public
	ControlBlock( String p_data )
    {
		super( p_data.substring( 0, SIZE ) );
    }

	public String getTotalRecordSize() { return StringTools.substring( data,  0, 6 ).trim(); }
	public String getIdentifier()      { return StringTools.substring( data, 10, 4 ).trim(); }
	public String getRequestType()     { return StringTools.substring( data, 38, 2 ).trim(); }
	public String getMessageState()    { return StringTools.substring( data, 40, 2 ).trim(); }
	public String getMessageId()       { return StringTools.substring( data, 54, 6 ).trim(); }

	public boolean isFEDI()      { return this.getIdentifier().equalsIgnoreCase( FEDI ); }
	public boolean isFXML()      { return this.getIdentifier().equalsIgnoreCase( FXML ); }
	public boolean isEncrypted() { return ((this.data.charAt( 14 ) == '3') ? true : false); }


	public void
	setTotalRecordSize( String p_size )
	{
		String size = StringTools.padLeft( p_size, 6, '0' );

		this.data.replace( 0, 0 + 6, size );
	}


	public String
	toString()
	{
		StringBuffer buffer = new StringBuffer();

		buffer.append( "\nControl Block" );
		buffer.append( "\n   Total Record Size [" + getTotalRecordSize() + "]" );
		buffer.append( "\n   Identifier        [" + getIdentifier()      + "]" );
		buffer.append( "\n   Request Type      [" + getRequestType()     + "]" );
		buffer.append( "\n   Message State     [" + getMessageState()    + "]" );
		buffer.append( "\n   Data Encrypted    [" + isEncrypted()        + "]" );
		buffer.append( "\n   Message Id        [" + getMessageId()       + "]" );
		buffer.append( "\n" );

		return buffer.toString();
	}
}