package fccsc.manager.data.edi;

import intarsys.util.StringTools;


public class CourseListBlock
	extends AbstractBlock
{
	private String studentId    = "";
	private String studentName  = "";
	private String studentDOB   = "";
	private String dataCLB      = "";

    public
	CourseListBlock( String p_studentId, String p_data )
    {
		super( "" );

		this.studentId = p_studentId;
		this.dataCLB   = p_data;
    }

	public String getStudentId()   { return this.studentId; }
	public String getStudentName() { return this.studentName; }
	public String getStudentDOB()  { return this.studentDOB;  }


	/**
	 * Process the incoming data into a "response" EDI data structure.
	 * This structure is used to send "back" to its caller as part of a response.
	 */
	public void
	buildResponse()
	{
		this.studentName = this.dataCLB.substring( 13, 13 + 60 );
		this.studentDOB  = this.dataCLB.substring( 73, 73 +  8 );

		////////////////////////////////////////////////////////////////
		// Demographic section
		//
		this.data.append( StringTools.padRight( "", 8, ' ' ) );                //  8 filler
		this.data.append( "000100DEMOGRAF" );
		this.data.append( this.dataCLB.substring(  0,  0 +  7 ) );             // 12 fice + campus
		this.data.append( this.dataCLB.substring(  8,  8 +  4 ) );
		this.data.append( StringTools.padRight( this.studentId,   12, ' ' ) ); // 12 student id
		this.data.append( StringTools.padRight( this.studentName, 60, ' ' ) ); // 60 full name
		this.data.append( StringTools.padRight( this.studentDOB,   8, ' ' ) ); //  8 dob YYYYMMDD
		//
		// 1 foreign language flag
		this.data.append( (( this.dataCLB.charAt( 81 ) != ' ') ? "Y" : "N" )  );
		//
		// 1 gordon rule flag
		this.data.append( (( this.dataCLB.charAt( 82 ) != ' ') ? "Y" : "N" )  );
		//
		// 1 gen ed flag
		this.data.append( (( this.dataCLB.charAt( 83 ) != ' ') ? "Y" : "N" )  );
		//
		this.data.append( StringTools.padRight( "", 6, ' ' ) );          //  6 filler
		this.data.append( "\n" );                                        //    linefeed character


		////////////////////////////////////////////////////////////////
		// Courselist section
		//
		String courseList    = this.dataCLB.substring( 100 ).trim();
		String courseSegment = "";

		while ( courseList.length() >= 99 )
		{
			this.data.append( StringTools.padRight( "", 8, ' ' ) );          //  8 filler
			this.data.append( "000119COURSLST" );

			courseSegment = courseList.substring( 0, 99 );
			courseList    = courseList.substring( 99 );

		    //System.out.println( "courseSegment [" + courseSegment + "]" );
		    //System.out.println( "   courseList [" + courseList    + "]" );

			this.data.append( courseSegment );                      // 99 course segment
			this.data.append( StringTools.padRight( "", 20, ' ' ) );         // 20 filler
			this.data.append( "\n" );
		}
	}


	/**
	 * Process the incoming data into a "request" EDI data structure.
	 * This structure is used to "send" to broker as a parameter for a request.
	 */
       public void
       buildRequest()
       {
              // 8 (whitespace) + 6 (000119) + 8 (COURSLST)
              int offset = 8 + 6 + 8;

              this.studentName = StringTools.substring( this.dataCLB, offset + 23, 60 );
              this.studentDOB  = StringTools.substring( this.dataCLB, offset + 83,  8 );

              //System.out.println( "studentName [" + studentName + "]" );
              //System.out.println( "studentDOB  [" + studentDOB  + "]" );

		////////////////////////////////////////////////////////////////
		// Courselist section
		//
		String courseList    = this.dataCLB.substring( offset + 100 );
		String courseSegment = "";

		while ( courseList.length() >= 142 )
		{
			// offset + 119 (data) = 141
			courseSegment = courseList.substring( 0, 142 );
			courseList    = courseList.substring( 142 );

			//System.out.println( "courseSegment [" + courseSegment + "]" );
			//System.out.println( "   courseList [" + courseList    + "]" );

			this.data.append( StringTools.substring( courseSegment, offset + 62, 3 ) );  // CurrCourse ENC
			this.data.append( StringTools.substring( courseSegment, offset + 66, 4 ) );  // CurrCourse 1102
                     this.data.append( StringTools.substring( courseSegment, offset + 71, 1 ) );  // CurrCourse C
                     this.data.append( StringTools.padRight( "", 2, ' ' ) );                      // 2 char filler
			this.data.append( StringTools.substring( courseSegment, offset + 80, 3 ) );  // Grade      W
			this.data.append( StringTools.substring( courseSegment, offset + 83, 6 ) );  // Credit     003000
			this.data.append( StringTools.substring( courseSegment, offset + 99, 1 ) );  // CRType     S
			this.data.append( StringTools.substring( courseSegment, offset + 78, 1 ) );  // Typ        0
			this.data.append( StringTools.substring( courseSegment, offset + 79, 1 ) );  // Repeat     .
			this.data.append( StringTools.substring( courseSegment, offset +  1, 6 ) );  // TermTaken  199808
		}
	}
}