package fccsc.manager.data.process;

import intarsys.mail.MailSender;
import intarsys.util.PropertyManager;
import intarsys.xml.SAXManager;

import java.util.Properties;
import java.util.Vector;

import javax.mail.MessagingException;

import fccsc.manager.broker.EntireXBroker;
import fccsc.manager.data.Email;
import fccsc.manager.data.ReturnCodes;
import fccsc.manager.data.edi.ControlBlock;
import fccsc.manager.data.xml.AdmissionResponseHandler;
import fccsc.manager.data.xml.ErrorHandler;


public final class Admission
	extends ProcessFXML
{
    public
	Admission()
    {
		super( "message.ADMISSION.properties" );
    }


	/**
	 * Interface Method - Processing method.
	 */
	public void
	process() throws Exception
	{
		super.process();

		// send the entire XML message
		String data = this.getXMLFactsMessage().getXML();

		EntireXBroker broker = new EntireXBroker( this.getProperties() );
		broker.sendMessage( data );

		// get response message
		String response   = broker.getResponse();
		String resRC      = ReturnCodes.CODE_00000;
		String resMessage = ReturnCodes.CODE_00000_MESSAGE;

		if ( logger.isDebugEnabled() )
		{
			logger.debug( "Broker Response [" + response + "]" );
		}

		if ( response.trim().length() == 0 )
		{
			resRC      = ReturnCodes.CODE_00048;
			resMessage = ReturnCodes.CODE_00048_MESSAGE;

			logger.error( "Error [" + resRC + " - " + resMessage + "]" );
		}
		else
		{
			/////////////////////////////////////////////////////////////////
			// test to check if data is an xml ERROR structure
			// if so, get STATUS information
			//
			ErrorHandler handlerError = new ErrorHandler();
			new SAXManager().parseSAXString( handlerError, response.trim() );

			if ( handlerError.isErrorMessage() )
			{
				response   = "";
				resRC      = ReturnCodes.CODE_00200;
				resMessage = handlerError.getStatus();

				logger.error( "Error [" + resRC + " - " + resMessage + "]" );
			}
			else // not an error message
			{
				/////////////////////////////////////////////////////////////////
				// parse ADMISSION_RESP message and get CONFIRM number
				// then build response message
				//
				AdmissionResponseHandler handler = new AdmissionResponseHandler();
				new SAXManager().parseSAXString( handler, response.trim() );

				if ( handler.isAdmissionResponse() )
				{
					response   = "<ADMISSION_RESP Type='C'>" + handler.getConfirm() + "</ADMISSION_RESP>";
					resRC      = handler.getReturnCode();
					resMessage = handler.getReturnMessage();

					this.processEmails( handler.getEmails() );
				}
			}
		}

		this.getXMLFactsMessage().setRequest(       "N"      );  // PLOG 23579
		this.getXMLFactsMessage().setRequestData(   response   );
		this.getXMLFactsMessage().setReturnCode(    resRC      );
		this.getXMLFactsMessage().setReturnMessage( resMessage );


		this.getEDIControlBlock();
		//////////////////////////////////////////////////////////////
		// build response and store
		//
		int lenCB    = ControlBlock.SIZE;
		int lenFM    = this.getXMLFactsMessage().getXML().length();
		int lenTotal = lenCB + lenFM;

	    this.getEDIControlBlock().setTotalRecordSize( String.valueOf( lenTotal ) );

		this.setResponse(   this.getEDIControlBlock().getData() +
						    this.getXMLFactsMessage().getXML() );
	}


	private void
	processEmails( Vector<Email> p_vEmails )
	{
		String mailActive = this.getProperties().getProperty( "mail.notification" );

		if ( ! mailActive.equalsIgnoreCase( "ON" ) )
		{
		    //System.out.println( "Email notification is [" + mailActive + "]. (message.ADMISSION.properties)" );
			logger.warn( "Email notification is [" + mailActive + "]. (message.ADMISSION.properties)" );
		}
		// notification is ON !
		else
		{
		    if ( logger.isDebugEnabled() )
			{
				logger.debug( "Sending [" + p_vEmails.size() + "] email notifications ... " );
			}

			Properties prop     = PropertyManager.getProperty( "mail.properties" );
			MailSender mail     = new MailSender( prop );
			Email      email    = null;
			Vector<String> vAddress = null;

			for ( int i = 0; i < p_vEmails.size(); i++ )
			{
				email = p_vEmails.elementAt( i );

				if ( logger.isDebugEnabled() )
				{
					logger.debug( "Sending [" + i + "] " + email.toString() );
				}

				// add FROM addresses
				vAddress = email.getAddressFROM();
				if ( vAddress != null )
				{
					for ( int j = 0; j < vAddress.size(); j++ )
					{
						// set the intial from address
						if ( j == 0 ) { mail.setAddressFROM( vAddress.elementAt( j ) ); }

						mail.addAddressFROM( vAddress.elementAt( j ) );
					}
				}

				// add TO addresses
				vAddress = email.getAddressTO();
				if ( vAddress != null )
				{
					for ( int j = 0; j < vAddress.size(); j++ )
					{
						mail.addAddressTO( vAddress.elementAt( j ) );
					}
				}

				// add CC addresses
				vAddress = email.getAddressCC();
				if ( vAddress != null )
				{
					for ( int j = 0; j < vAddress.size(); j++ )
					{
						mail.addAddressCC( vAddress.elementAt( j ) );
					}
				}

				// add BCC addresses
				vAddress = email.getAddressBCC();
				if ( vAddress != null )
				{
					for ( int j = 0; j < vAddress.size(); j++ )
					{
						mail.addAddressBCC( vAddress.elementAt( j ) );
					}
				}

				try
				{
					mail.setContentType( email.getContentType() );
					mail.setSubject( email.getSubject() );
					mail.setMessage( email.getBody() );
					mail.send();
					mail.clear();
				}
				catch ( MessagingException ex )
				{
					logger.error( "Sending mail notification [" + ex.getMessage() + "]" );
				}
			}
		}
	}
}

