package fccsc.manager.data.process;

import intarsys.xml.SAXManager;
import fccsc.manager.broker.EntireXBroker;
import fccsc.manager.data.ReturnCodes;
import fccsc.manager.data.edi.ControlBlock;
import fccsc.manager.data.xml.ErrorHandler;



public final class Advise22
	extends ProcessFXML
{
    public
	Advise22()
    {
		super( "message.22ADVISE.properties" );
    }


	/**
	 * Interface Method - Processing method.
	 */
	public void
	process() throws Exception
	{
		super.process();

		String data = this.getXMLFactsMessage().getXML();

		EntireXBroker broker = new EntireXBroker( this.getProperties() );
		broker.sendMessage( data );

		// get response message
		String response   = broker.getResponse().trim();
		String resRC      = ReturnCodes.CODE_00000;
		String resMessage = ReturnCodes.CODE_00000_MESSAGE;

		if ( logger.isDebugEnabled() )
		{
			logger.debug( "Broker Response [" + response + "]" );
		}

		if ( response.trim().length() == 0 )
		{
			resRC      = ReturnCodes.CODE_00012;
			resMessage = ReturnCodes.CODE_00012_MESSAGE;

			logger.error( "Error [" + resRC + " - " + resMessage + "]" );
		}
		else
		{
			/////////////////////////////////////////////////////////////////
			// test to check if data is an xml ERROR structure
			//
			ErrorHandler handler = new ErrorHandler();
			new SAXManager().parseSAXString( handler, response.trim() );

			if ( handler.isErrorMessage() )
			{
				this.getXMLFactsMessage().setRequestData( "" );

				resRC      = ReturnCodes.CODE_00200;
				resMessage = handler.getStatus();
				response   = this.getXMLFactsMessage().getXML();

				logger.error( "Error [" + resRC + " - " + resMessage + "]" );
			}
		}

		this.getXMLFactsMessage().setReturnCode(    resRC      );
		this.getXMLFactsMessage().setReturnMessage( resMessage );

		this.getEDIControlBlock();
		//////////////////////////////////////////////////////////////
		// build response and store
		//
		int lenTotal = ControlBlock.SIZE + response.length();

		this.getEDIControlBlock().setTotalRecordSize( String.valueOf( lenTotal ) );

		this.setResponse( this.getEDIControlBlock().getData() + response );
	}
}