package fccsc.manager.data.process;

/**
 * PBSC History
 * ************
 * PBSC palermor IR158889 01/06/2016 Increased #OUT-BUFFER from 300 to 327. 
 *                                   Use substring() with just start index so it gets all of the data.
 *                                   Do not trim trailing spaces on lines so things line up better when centered via HTML.
 *                                   HTML tweaks.
 *                                   
 * 04/20/2017	Ian Peterson	Log 23809: Increase student password from 6 chars to 15 chars.
 */

import org.apache.commons.lang3.StringEscapeUtils;

import fccsc.manager.broker.EntireXBroker;
import fccsc.manager.data.ReturnCodes;
import fccsc.manager.util.TemplateManager;
import intarsys.util.StringTools;


public final class GradAudit
	extends ProcessFEDI
{
	private StringBuffer data = new StringBuffer();


	/**
	 * Creates an object to process a GRADAUDIT message.
	 */
    public
	GradAudit()
    {
		super( "message.GRADAUDIT.properties" );
    }


	/**
	 * Interface Method - Processing method.
	 * @throws Exception
	 */
	public void
	process() throws Exception
	{
		super.process();

		String studId  = this.getEDIStandardDataBlock().getStudentID();
		String studPwd = this.getEDIStandardDataBlock().getPinPassword();
		String program = "     ";  // 5 bytes
		String award   = "   ";    // 3 bytes
		String term    = "      "; // 6 bytes

		studId  = StringTools.padRight( studId,  9,  ' ' );
		studPwd = StringTools.padRight( studPwd, 15, ' ' );			// Log 23809

		String data = studId + studPwd + program + award + term;

		EntireXBroker broker = new EntireXBroker( this.getProperties() );
		broker.sendMessage( data );

		// get response message
		String response    = broker.getResponse();
		//String resParams   = (String) response.substring(     0,     0 +    29 );
		//String resExpand   = (String) response.substring(    29,    29 +    68 );
		String resRC       = response.substring(    97,    97 +     4 );
		String resDA       = response.substring(   101);// ,   101 + 23700 );  // PBSC palermor IR158889
		//String resExpand2  = (String) response.substring( 23801, 23801 +  2199 );
		String resMessage  = "";

		if ( logger.isDebugEnabled() )
		{
			logger.debug( "Broker Response [" + response + "]" );
		}

		if ( resRC.equalsIgnoreCase( "0000" ) )
		{
		    resRC      = ReturnCodes.CODE_00000;
			resMessage = ReturnCodes.CODE_00000_MESSAGE;
		}
		else
		{
			resMessage = resDA.trim();
		}

		if ( resDA.trim().length() == 0 )
		{
		    resRC      = ReturnCodes.CODE_00048;
			resMessage = ReturnCodes.CODE_00048_MESSAGE;

			logger.error( "Error [" + resRC + " - " + resMessage + "]" );
		}

		if ( resRC.equalsIgnoreCase( ReturnCodes.CODE_00000 ) )
		{
		    processData( resDA );
		}

		this.getEDIStandardDataBlock().setRequest("N"); // PBSC palermor IR174860
		this.getEDIStandardDataBlock().setReturnCode(    resRC      );
    	this.getEDIStandardDataBlock().setReturnMessage( resMessage );

		//////////////////////////////////////////////////////////////
		// build response and store
		//
		StringBuffer buffer = new StringBuffer();

		int lenTRS   = Integer.parseInt( this.getEDIControlBlock().getTotalRecordSize() );
		int lenPDB   = this.data.length();
		int lenTotal = lenTRS + lenPDB;

		this.getEDIControlBlock().setTotalRecordSize( String.valueOf( lenTotal ) );

		buffer.append( this.getEDIControlBlock().getData() );
		buffer.append( this.getEDIStandardDataBlock().getData() );
		buffer.append( this.data.toString() );

		this.setResponse( buffer.toString() );
	}


	private void
	processData( String p_data )
	{
		////////////////////////////////////////////////////////////////
		// data parsing
		//
		StringBuffer buffer = new StringBuffer();
		String       html   = "";
		String       line   = "";   // 79 bytes
		int          MAX    = 79;   // max # bytes a line can have
		int          len    = p_data.length();

		for ( int i = 0; i < len; /**/ )
		{
			if ( (i + MAX) <= len )
			{
			    line = p_data.substring( i, i + MAX );
				i = i + MAX;
			}
			else
			{
			    line = p_data.substring( i );
				i = len;
			}

		    if ( line.trim().length() > 0 )
			{
				// adds this ... <HR> before this ...
				//                   *** Program of Study Course Requirements ***
				//
				if ( line.indexOf( "   *** " ) > -1 )
				{
					buffer.append( "</pre>\n" );  // PBSC palermor IR158889
					buffer.append( "<hr/>\n" );  // PBSC palermor IR158889
					buffer.append( "<pre>\n" );  // PBSC palermor IR158889
				}
				// adds this ... <HR Align=Center Width=65%> before this ...
				//     Area 01:(07A) GENERAL EDUCATION              Min.Hours:18.00 Min.Crses: 6
				//
				else if ( (line.indexOf( "   Area " ) > -1) && (line.indexOf( "Min.Crses" ) > -1) )
				{
					buffer.append( "</pre>\n" );  // PBSC palermor IR158889
					buffer.append( "<hr style=\"width: 65%;\"/>\n" );  // PBSC palermor IR158889
					buffer.append( "<pre>\n" );  // PBSC palermor IR158889
				}

				// PBSC palermor IR158889 START
				// trim off trailing spaces
				//line = StringTools.trimTrailingWhitespace( line );
				line = StringEscapeUtils.escapeHtml4(line);
				// PBSC palermor IR158889 END

			    buffer.append( line + "\n" );  // line + carriage return + linefeed character
				//System.out.println( "line a [" + line + "]" );
			}
		}

		////////////////////////////////////////////////////////////////
		// populate a template
		html = TemplateManager.populate( "GRADAUDIT.template", buffer.toString() );

		////////////////////////////////////////////////////////////////
		// build "Process Data Block" section
		//
		String lenHtml = String.valueOf( html.length() );

		this.data.append( StringTools.padRight(      "", 8, ' ' ) );  //  8 filler
		this.data.append( StringTools.padLeft(  lenHtml, 6, '0' ) );  //  6 html data length
		this.data.append( "AUDITDAT" );
		this.data.append( html );                                     //  ? html data
		this.data.append( "\n" );                                     //  1 linefeed character
	}
}