package fccsc.manager.data.process;

/**
 * PBSC History
 * ************
 * PBSC palermor 167972 10/02/2013 Add more data for error but only send the length of the student password for security.
 * PBSC palermor IR158889 01/06/2016 Increased #OUT-BUFFER from 300 to 327. 
 *                                   Use substring() with just start index so it gets all of the data.
 *                                   Do not trim trailing spaces on lines so things line up better when centered via HTML.
 *                                   HTML tweaks.
 * 
 * 04/20/2017	Ian Peterson	Log 23809: Increase student password from 6 chars to 15 chars.
 */

import intarsys.util.StringTools;

import org.apache.commons.lang3.StringEscapeUtils;

import fccsc.manager.broker.EntireXBroker;
import fccsc.manager.data.ReturnCodes;
import fccsc.manager.data.edi.ControlBlock;
import fccsc.manager.data.edi.LocalShopBlock;
import fccsc.manager.util.TemplateManager;


public final class LocalShop
	extends ProcessFEDI
{
	private static String  guestStudentId = "";
	private static boolean bLoadedGuestId = false;

	private StringBuffer data = new StringBuffer();


	/**
	 * Creates an object to process a LOCALSHOP message.
	 */
    public
	LocalShop()
    {
		super( "message.LOCALSHOP.properties" );
    }


	/**
	 * Interface Method - Processing method.
	 * @throws Exception
	 */
	public void
	process() throws Exception
	{
		super.process();

		LocalShopBlock ediLSB = new LocalShopBlock( this.getRequest() );

		String studId  = this.getEDIStandardDataBlock().getStudentID();
		String studPwd = this.getEDIStandardDataBlock().getPinPassword();
		String program = ediLSB.getMajor();  // 5 bytes
		String award   = "   ";              // 3 bytes
		String term    = "      ";           // 6 bytes

		// check for "GST" in student id
		if ( studId.trim().equalsIgnoreCase( "GST" ) )
		{
			studId = checkForGuest( studId );
			System.out.println( "Guest Student ID [" + studId + "] (message.LOCALSHOP.properties)" );
			logger.info( "Guest Student ID [" + studId + "] (message.LOCALSHOP.properties)" );
		}

		studId  = StringTools.padRight( studId,  9,  ' ' );
		studPwd = StringTools.padRight( studPwd, 15, ' ' );			// Log 23809
		program = StringTools.padRight( program, 5,  ' ' );

		String data = studId + studPwd + program + award + term;

		// PBSC palermor 167972 Add data sent but only pass length of student password.
		String dataSent = "DataSent: stuId[" + studId + "] studPwd.length[" + studPwd.length() + "] program[" + program + "] award[" + award + "] term[" + term + "]";

		EntireXBroker broker = new EntireXBroker( this.getProperties() );
		broker.sendMessage( data );

		// get response message
		String response    = broker.getResponse();
		//String resParams   = (String) response.substring(     0,     0 +    29 );
		//String resExpand   = (String) response.substring(    29,    29 +    68 );
		String resRC       = response.substring(    97,    97 +     4 );
		String resDA       = response.substring(   101);//,   101 + 23700 );  // PBSC palermor IR158889
		//String resExpand2  = (String) response.substring( 23801, 23801 +  2199 );
		String resMessage  = "";

		if ( logger.isDebugEnabled() )
		{
			logger.debug( "Broker Response [" + response + "]  " + dataSent); // PBSC palermor 167972
		}

		if ( resDA.trim().length() == 0 )
		{
		    resRC      = ReturnCodes.CODE_00048;
			resMessage = ReturnCodes.CODE_00048_MESSAGE;
			
			logger.error( "Error [" + resRC + " - " + resMessage + "]  " + dataSent); // PBSC palermor 167972
		}
		else if ( resRC.equalsIgnoreCase( "0000" ) )
		{
		    resRC      = ReturnCodes.CODE_00000;
			resMessage = ReturnCodes.CODE_00000_MESSAGE;

		    processData( resDA );
		}
		else
		{
			resMessage = resDA.trim();

			logger.error( "Error [" + resRC + " - " + resMessage + "]  " + dataSent); // PBSC palermor 167972
		}

		this.getEDIStandardDataBlock().setRequest("N"); // PBSC palermor IR174860
		this.getEDIStandardDataBlock().setReturnCode(    resRC );
		this.getEDIStandardDataBlock().setReturnMessage( resMessage );


		//////////////////////////////////////////////////////////////
		// build response and store
		//
		StringBuffer buffer = new StringBuffer();

		int lenCB    = ControlBlock.SIZE;
		int lenSDB   = this.getEDIStandardDataBlock().getData().length();
		int lenPDB   = this.data.length();
		int lenTotal = lenCB + lenSDB + lenPDB;

		this.getEDIControlBlock().setTotalRecordSize( String.valueOf( lenTotal ) );

		buffer.append( this.getEDIControlBlock().getData() );
		buffer.append( this.getEDIStandardDataBlock().getData() );
		buffer.append( this.data.toString() );

		this.setResponse( buffer.toString() );
	}


	private void
	processData( String p_data )
	{
		////////////////////////////////////////////////////////////////
		// data parsing
		//
		StringBuffer buffer = new StringBuffer();
		String       html   = "";
		String       line   = "";   // 79 bytes
		int          MAX    = 79;   // max # bytes a line can have
		int          len    = p_data.length();

		for ( int i = 0; i < len; /**/ )
		{
			if ( (i + MAX) <= len )
			{
			    line = p_data.substring( i, i + MAX );
				i = i + MAX;
			}
			else
			{
			    line = p_data.substring( i );
				i = len;
			}

		    if ( line.trim().length() > 0 )
			{
				// adds this ... <HR> before this ...
				//                   *** Program of Study Course Requirements ***
				//
				if ( line.indexOf( "   *** " ) > -1 )
				{
					buffer.append( "</pre>\n" );  // PBSC palermor IR158889
					buffer.append( "<hr/>\n" );
					buffer.append( "<pre>\n" );  // PBSC palermor IR158889
				}
				// adds this ... <HR Align=Center Width=65%> before this ...
				//     Area 01:(07A) GENERAL EDUCATION              Min.Hours:18.00 Min.Crses: 6
				//
				else if ( (line.indexOf( "   Area " ) > -1) && (line.indexOf( "Min.Crses" ) > -1) )
				{
					buffer.append( "</pre>\n" );  // PBSC palermor IR158889
					buffer.append( "<hr style=\"width: 65%;\"/>\n" );
					buffer.append( "<pre>\n" );  // PBSC palermor IR158889
				}

				// PBSC palermor IR158889 START
				// trim off trailing spaces
				//line = StringTools.trimTrailingWhitespace( line );
				line = StringEscapeUtils.escapeHtml4(line);
				// PBSC palermor IR158889 END

			    buffer.append( line + "\n" );  // line + carriage return + linefeed character
				//System.out.println( "line a [" + line + "]" );
			}
		}

		////////////////////////////////////////////////////////////////
		// populate a template
		html = TemplateManager.populate( "LOCALSHOP.template", buffer.toString() );

		////////////////////////////////////////////////////////////////
		// build "Process Data Block" section
		//
		String lenHtml = String.valueOf( html.length() );

		this.data.append( StringTools.padRight(      "", 8, ' ' ) );  //  8 filler
		this.data.append( StringTools.padLeft(  lenHtml, 6, '0' ) );  //  6 html data length
		this.data.append( "AUDITDAT" );
		this.data.append( html );                                     //  ? html data
		this.data.append( "\n" );                                     //  1 linefeed character
	}


	private String
	checkForGuest( String p_studentId )
	{
		String studId = "";

		if ( bLoadedGuestId ) { studId = guestStudentId; }
		else
		{
			guestStudentId = this.getProperties().getProperty( "guest.student.id" );
		    bLoadedGuestId = true;
			studId         = guestStudentId;
		}

		return studId;
	}
}
