package fccsc.manager.data.process;

/**
 * PBSC History
 * ************
 * PBSC palermor IR84565 05/19/2015 Update to log4j2.
 */

import intarsys.util.PropertyManager;

import java.util.Properties;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import fccsc.manager.IMessage;
import fccsc.manager.data.edi.ControlBlock;


public abstract class Process
	implements IMessage
{
    protected static Logger logger = null;

	private Properties   properties = null;
	private ControlBlock ediCB      = null;
	private String       request    = "";
	private String       response   = "";

	private String callBackIpAddress = "";
	private int    callBackIpPort    = 0;


    public
	Process( String p_propertiesFileName )
    {
		this.properties = PropertyManager.getProperty( p_propertiesFileName );
		logger     = LogManager.getLogger( this.getClass().getName() );  // PBSC palermor IR84565
    }


	/**
	 * Returns the Properties file loaded for this object.
	 * @return a properties object.
	 */
	public Properties
	getProperties() { return this.properties; }


	/**
	 * Returns the EDI Control Block parsed from the data.
	 * @return edi control block.
	 */
	public ControlBlock
	getEDIControlBlock() { return this.ediCB;  }


	/**
	 * Interface Method - Returns the response message that this process needs to send back.
	 * @return response message.
	 * @throws Exception
	 */
	public String
	getResponse() throws Exception { return this.response; }


	/**
	 * Sets the outgoing response data.
	 * @param p_data the response data.
	 * @throws Exception
	 */
	public void
	setResponse( String p_data ) throws Exception
	{
		this.response = p_data;
	}


	/**
	 * Interface Method - Returns the request data that was sent to this process.
	 * @return the request data.
	 * @throws Exception
	 */
	public String
	getRequest() throws Exception { return this.request; }


	/**
	 * Interface Method - Sets the incoming data to process.
	 * @param p_data the data to be processed.
	 * @throws Exception
	 */
	public void
	setRequest( String p_data ) throws Exception
	{
		this.request = p_data;
		this.ediCB   = new ControlBlock( this.request );
	}


	/**
	 * Returns the Logger associated with this object.
	 * @return a logger object.
	 */
	public Logger
	getLogger() { return logger; }



	/**
	 * Interface Method - Process this message.
	 * @throws Exception
	 */
	public void
	process() throws Exception
    {
		if ( logger.isDebugEnabled() )
		{
			System.out.println( "Processing [" + logger.getName() + "]" );
		}
		logger.info( "Processing ..." );
	}


	/**
	 * Returns the "call back" ip address.
	 * @return a string representation of an ip address (xxx.xxx.xxx.xxx).
	 */
	public String getCallBackIpAddress() { return this.callBackIpAddress; }

	/**
	 * Sets the "call back" ip address.
	 * @param p_ipAddress a string representation of an ip address (xxx.xxx.xxx.xxx).
	 */
	public void setCallBackIpAddress( String p_ipAddress ) { this.callBackIpAddress = p_ipAddress; }


	/**
	 * Returns the "call back" ip port.
	 * @return an integer.
	 */
	public int getCallBackIpPort() { return this.callBackIpPort; }

	/**
	 * Sets the "call back" ip port.
	 * @param p_ipPort the ip port.
	 */
	public void setCallBackIpPort( int p_ipPort ) { this.callBackIpPort = p_ipPort; }
}