package fccsc.manager.data.process;

import fccsc.manager.data.xml.FactsMessage;

public abstract class ProcessFXML
	extends Process
{
	private FactsMessage factsMessage = null;


	/**
	 * Creates an object to process XML type messages.
	 * @param p_propertiesFileName the properties file to load configuration information from.
	 */
    public
	ProcessFXML( String p_propertiesFileName )
    {
		super( p_propertiesFileName );
    }


	/**
	 * Returns the FactsMessage object.
	 * @return a facts message object.
	 */
	public FactsMessage getXMLFactsMessage() { return this.factsMessage; }


	/**
	 * Sets the incoming data to process.
	 * @param p_data the data to be processed.
	 * @throws Exception
	 */
	public void
	setRequest( String p_data ) throws Exception
	{
		super.setRequest( p_data );

		this.factsMessage = new FactsMessage( super.getRequest() );

		this.setCallBackIpAddress( this.factsMessage.getIpAddress() );
		this.setCallBackIpPort( Integer.parseInt( this.factsMessage.getIpPort() ) );
	}
}