package fccsc.manager.data.xml;

import fccsc.manager.data.Email;
import intarsys.xml.handler.XMLHandler;

import java.util.Vector;

import org.xml.sax.AttributeList;


@SuppressWarnings("deprecation")
public class AdmissionResponseHandler
	extends XMLHandler
{
	private String value         = "";
	private String confirm       = "";
	private String returnCode    = "";
	private String returnMessage = "";
	private Vector<Email> vEmail        = new Vector<Email>( 2, 2 );
	private Email  email         = null;

	private boolean isAdmissionResponse = false;
	private boolean inEmailBlock        = false;


    public
	AdmissionResponseHandler()
    {
    }


	public String  getConfirm()          { return this.confirm; }
	public String  getReturnCode()       { return this.returnCode; }
	public String  getReturnMessage()    { return this.returnMessage; }
	public boolean isAdmissionResponse() { return this.isAdmissionResponse; }
	public Vector<Email>  getEmails()           { return this.vEmail; }



	public void
	startElement( String name, AttributeList atts )
	{
		if ( name.equalsIgnoreCase( "EMAIL" ) )
		{
			email        = new Email( super.getAttribute( atts, "CONTENTTYPE" ) );
			inEmailBlock = true;
		}
	}


	public void
	endElement( String name )
	{
		value = super.getElementValue();

		if ( inEmailBlock ) { processEmailBlock( name, value ); }


		if (      name.equalsIgnoreCase( "CONFIRM"  ) ) { this.confirm       = value; }
		else if ( name.equalsIgnoreCase( "RETNCODE" ) ) { this.returnCode    = value; }
		else if ( name.equalsIgnoreCase( "RETNMESS" ) ) { this.returnMessage = value; }
		else if ( name.equalsIgnoreCase( "EMAIL" ) )
		{
			this.vEmail.addElement( email );
		    //System.out.println( email.toString() );

			inEmailBlock = false;
		}
		else if ( name.equalsIgnoreCase( "ADMISSION_RESP" ) ) { isAdmissionResponse = true; }

		super.clearElementValue();
	}



	private void
	processEmailBlock( String name, String value )
	{
		if ( value.trim().length() > 0 )
		{
			if (      name.equalsIgnoreCase( "FROM"    ) ) { email.addAddressFROM( value ); }
	    	else if ( name.equalsIgnoreCase( "TO"      ) ) { email.addAddressTO(   value ); }
			else if ( name.equalsIgnoreCase( "CC"      ) ) { email.addAddressCC(   value ); }
	    	else if ( name.equalsIgnoreCase( "BCC"     ) ) { email.addAddressBCC(  value ); }
		    else if ( name.equalsIgnoreCase( "SUBJECT" ) ) { email.setSubject(     value ); }
		    else if ( name.equalsIgnoreCase( "BODY"    ) ) { email.setBody(        value ); }
		}
	}
}