package fccsc.manager.util;

/**
 * PBSC History
 * ************
 * PBSC palermor IR84565 05/19/2015 Update to log4j2.
 */

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


public final class TemplateManager
{
	private static Logger    logger        = LogManager.getLogger( TemplateManager.class );  // PBSC palermor IR84565
	private static Hashtable<String, String> hTemplates    = new Hashtable<String, String>();
	private static String    directoryPath = "";


//	public static void
//	main( String [] args )
//	{
//		try
//		{
//			File f = new File( "." );
//			TemplateManager.init(   f.getCanonicalPath() +
//								    f.separator + "jars" + f.separator + "templates" );
//			TemplateManager.loadAll();
//
//		    System.out.println( "listing   [" + TemplateManager.display() + "]" );
//
//			String template = TemplateManager.populate( "TRANSCRIPT.template", "BLAH BLAH BLAH" );
//
//			System.out.println( "populated [" + template + "]" );
//		}
//		catch (IOException ex)
//		{
//			ex.printStackTrace();
//		}
//	}

	/**
	 * Initializes this manager with the location (directory path)
	 * of template files to load.
	 *
	 * @param p_directoryPath the absolute directory path, i.e... D:\\manager\\templates
	 */
    public static void
	init( String p_directoryPath )
    {
		directoryPath = p_directoryPath;
    }


	/**
	 * Display a listing of all loaded template files.
	 * @return a string representation of internal data.
	 */
	public static String
	display()
	{
		StringWriter buffer = new StringWriter();
		Enumeration<String>  enums  = hTemplates.keys();
		String       name   = "";
		String       data   = "";

		while ( enums.hasMoreElements() )
		{
			name = enums.nextElement();
		    data = hTemplates.get( name );

			buffer.write( "\n" + name + " [" + data + "]" );
		}

		return buffer.toString();
	}


	/**
	 * Loads all the (*.template) files from our root directory path
	 * provided in the constructor of this object. This method filters
	 * out all *.template files and loads each file into an internal
	 * hashtable data structure and maps the loaded Template file
	 * with its file * name (<filename>.template).
	 */
	public static void
	loadAll()
	{
		hTemplates.clear();

		try
		{
			File f = new File( directoryPath );

		    if ( f.isDirectory() )
			{
			    String [] arrFiles = f.list();

				for (int i = 0; i < arrFiles.length; i++)
				{
					if ( arrFiles[i].endsWith( "template" ) )
					{
						load( arrFiles[i] );
					}
				}
			}
		}
		catch (Exception ex)
		{
			logger.error( "Error trying to load all templates [{}]", ex.getMessage() );  // PBSC palermor IR84565
		}
	}


	/**
	 * Loads a (*.template) file from our root directory path
	 * provided in the constructor of this object. This method loads
	 * the file into an internal hashtable data structure and maps
	 * the loaded Template file with its file name (<p_filename>.template).
	 *
	 * @param p_fileName the template file to load.
	 */
	public static void
	load( String p_fileName )
	{
		BufferedReader  result = null;
		
		try
		{
			String path = directoryPath + File.separator + p_fileName;
			File   f    = new File( path );

			if ( f.exists() )
			{
				FileInputStream fin    = new FileInputStream( f );
	    		result = new BufferedReader( new InputStreamReader( fin ) );

				String       line   = "";
	    		StringBuffer buffer = new StringBuffer();

				while ( (line = result.readLine() ) != null )
	    		{
		    		buffer.append( line );
			    }

				//System.out.println( "template file name [" + f.getName() + "]" );
				hTemplates.put( f.getName(), buffer.toString() );
			}
			else
			{
				logger.error( "Error trying to load template ({}). File does not exist !", path );  // PBSC palermor IR84565
			}
		}
		catch (Exception ex)
		{
			logger.error( "Error trying to load templates ({})", p_fileName );  // PBSC palermor IR84565
		}
		finally
		{
			if(result != null){
				try
				{
					result.close();
				}
				catch (Exception e)
				{
					//Do nothing.
				}
			}
		}
	}


	/**
	 * Parses and loads the specified template with the given data.
	 *
	 * @param p_templateName the template to parse and load.
	 * @param p_data         the data to insert into the template.
	 * @return a string of the template after data insertion.
	 */
	public static String
	populate( String p_templateName, String p_data )
	{
		StringBuffer buffer = new StringBuffer();

		if ( hTemplates.containsKey( p_templateName ) )
		{
			String INSERT_TAG     = "<!REPORT>";
			String templateData   = hTemplates.get( p_templateName );

			int    begin          = templateData.indexOf( INSERT_TAG );
			String templateTop    = templateData.substring( 0, begin );
			String templateBottom = templateData.substring(    begin + INSERT_TAG.length() );

			buffer.append( templateTop );
			buffer.append( p_data );
			buffer.append( templateBottom );

			//System.out.println( "Template:           " + templateData );
			//System.out.println( "Template-Top:       " + templateTop    );
			//System.out.println( "Template-Bottom:    " + templateBottom );
			//System.out.println( "Template-Populated: " + buffer.toString() );
		}

		return buffer.toString();
	}
}