/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.MerchantConfig;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import org.bouncycastle.util.encoders.Base64;

class ConnectionHelper {
    ConnectionHelper() {
    }

    public static boolean getDefaultUseHttpClient() {
        return false;
    }

    public static void setTimeout(HttpURLConnection con, int timeout) {
        int timeoutInMS = timeout * 1000;
        con.setConnectTimeout(timeoutInMS);
        con.setReadTimeout(timeoutInMS);
    }

    public static HttpURLConnection openConnection(URL url, MerchantConfig mc) throws IOException {
        Proxy proxy = ConnectionHelper.createProxy(mc);
        HttpURLConnection con = (HttpURLConnection)url.openConnection(proxy);
        if (proxy != Proxy.NO_PROXY) {
            ConnectionHelper.addProxyCredentials(con, mc);
        }
        return con;
    }

    private static Proxy createProxy(MerchantConfig mc) {
        if (mc.getProxyHost() == null) {
            return Proxy.NO_PROXY;
        }
        InetSocketAddress addr = new InetSocketAddress(mc.getProxyHost(), mc.getProxyPort());
        return new Proxy(Proxy.Type.HTTP, addr);
    }

    private static void addProxyCredentials(HttpURLConnection con, MerchantConfig mc) {
        if (mc.getProxyUser() != null) {
            con.setRequestProperty("Proxy-Authorization", "Basic " + Base64.encode((byte[])(mc.getProxyUser() + ":" + mc.getProxyPassword()).getBytes(Charset.forName("UTF-8"))));
        }
    }
}

